* This program prepares the input for the matlab favar program. It will output Input.xls directly into the matlab data folder where the matlab program can read it.

capture program drop MakeMatlabInput
program define MakeMatlabInput

	******************
	* Parameters
	******************

	*set to "Broad" to use Broad variables for the Economic Activity Factor. Set to "Narrow" to use the Narrow variables for the EA factor.
	local BroadOrNarrow = "`1'"

	*set to "MOM" if the input data are seasonally adjusted month-over-month growth rates
	*set to "YOY" if the input data are NSA 12-month growth rates
	local MOMorYOY = "MOM"

	*set to "CNYadj" to use the data with Chinese New Year adjustment. Set to "noCNYadj" to use the data without CNY adjustment
	local CNYadj = "`2'"

	*set to "" to use the data without biweight filtered series. Set to " BW36" to use the data with biweighted filtered series with parameter 36. Set to " BW120" to use the filtered series with parameter 120.
	local BW = "`3'"

	*set to the date range of the dataset you want to use. Set to "19991_201310" for 1999m1-2013m10. Set to "19901_201310" to use 1990m1-2013m10. Set to "19941_201310" to use 1994m1-2013m10. In the end we settled on "20001_201310" in the December 2013 draft.
	local DateRange = "20001_201310"

	*set to 0 to put all proxy variables in one big group, as opposed to separating "economic activity series" and "price series".
		*If you want separate factors for the economic activity variables and the price variables, then you should set this parameter to 1.
	local SeparateCategories = `4'





	***locals set automatically based on the parameters
	if "`BroadOrNarrow'"=="Broad"{
		local EAVars = "GasConsumption ConsumerIndex Retail IP ElectricityConsumption ElectricityProduction Rail Property_RealEstate CrudeSteel Trucks PMI PMI_Export FloorSpace EmpIndustrial ConsumerConfidenceIndex TradeBalance ImportPetroleum ForeignReserve FXRate FAI FAIConstruction FAIEquipment PMI_nonmfg ShanghaiSE ShenzhenSE ShanghaiShenzhen300 PEShanghaiSE PEShenzhenSE RealEstateClimate ExportFOB"
	}
	if "`BroadOrNarrow'"=="Narrow"{
		local EAVars = "ElectricityProduction FloorSpace ExportFOB"
	}
	if "`MOMorYOY'"=="MOM"{
		local PRVars = "CPI CPICore CPIFood CPI36Cities"
		local ReadFile = "transformed data (MOM `CNYadj'`BW' `DateRange').dta"
	}
	if "`MOMorYOY'"=="YOY"{
		local PRVars = "CPI CPICore CPIFood CPI36Cities PPIBeijing_YOY PPIIndustrial_YOY"
		local ReadFile = "transformed data (YOY `CNYadj'`BW' `DateRange').dta"
	}







	******************************
	* Main Program
	*******************************
	*read in data
	use "../clean data/`ReadFile'", clear

	order `EAVars' `PRVars'
	keep  `EAVars' `PRVars'

	*add additional labels for matlab program to read in
	local Nobs      = _N
	local NobsPlus1 = _N+1
	local NobsPlus2 = _N+2
	local NobsPlus3 = _N+3
	set obs `NobsPlus3'

	*move the last 3 observations to be the first 3 observations
	gen     counter  = _n
	gen     counter2 = .
	*add two to every counter for each of teh original observations
	replace counter2 = counter+2      if counter<=`Nobs'
	*and for the last 3 observations that we added, make them nubmer 1, 2, and 3
	replace counter2 = counter-`Nobs' if counter >`Nobs'
	*sort by our new ordering
	sort counter2
	drop counter counter2

	foreach v in `EAVars'{
		*turn the variable into a string
		gen `v'2 = string(`v')
		drop `v'
		rename `v'2 `v'
		
		*add labels to the first two observations
		replace `v'="EA"   if _n==1
		replace `v'="NONE" if _n==2
		
		*add the variable name to the 3rd observation
		replace `v'="`v'" if _n==3
	}

	foreach v in `PRVars'{
		*turn the variable into a string
		gen `v'2 = string(`v')
		drop `v'
		rename `v'2 `v'
		
		*add labels to the first two observations
		if `SeparateCategories'==1 {
			replace `v'="PR"   if _n==1
		}
		if `SeparateCategories'==0 {
			replace `v'="EA"   if _n==1
		}
		
		*specify that no transformation is to be done on the variables
		replace `v'="NONE" if _n==2
		
		*add the variable name to the 3rd observation
		replace `v'="`v'" if _n==3
	}

	*make a copy of the matlab input template, and then write in our new matlab input data
	copy  "../../(2) Matlab files/data/Input template for STATA.xls" "../../(2) Matlab files/data/Input.xls", replace
	export excel using "../../(2) Matlab files/data/Input.xls", sheet("Monthly") cell(C1) sheetmodify

end





******************
* Function calls
******************

* Call this function and...
*       in the Matlab program set Neafactors = 1 and Nprfactors = 1 to make "factors_BroadMOM (CNYadj BW36 20001_201310).xls"
*       in the Matlab program set Neafactors = 2 and Nprfactors = 1 to make "factors_BroadMOM (CNYadj BW36 20001_201310) TwoEAFactors.xls"
MakeMatlabInput Broad  CNYadj   " BW36" 1



* Call this function and...
*       in the Matlab program set Neafactors = 2 and Nprfactors = 0 to make "factors_BroadMOM (CNYadj BW36 20001_201310) NotSeparate.xls"
MakeMatlabInput Broad  CNYadj   " BW36" 0



* Call this function and...
*       in the Matlab program set Neafactors = 1 and Nprfactors = 1 to make "factors_BroadMOM (CNYadj noBW 20001_201310).xls"
MakeMatlabInput Broad  CNYadj   ""      1



* Call this function and...
*       in the Matlab program set Neafactors = 1 and Nprfactors = 1 to make "factors_BroadMOM (noCNYadj BW36 20001_201310).xls"
MakeMatlabInput Broad  noCNYadj " BW36" 1



* Call this function and...
*       in the Matlab program set Neafactors = 1 and Nprfactors = 1 to make "factors_NarrowMOM (CNYadj BW36 20001_201310).xls"
MakeMatlabInput Narrow CNYadj   " BW36" 1

